	function [Gbs, Zbs, Pbs ] = PZ_2_G_SYM_BS_S(G, Z, P, Wi2)
 
	% Transforms poles and zeros of an analog lowpass filter with unity 
	% cutoff frequency to a bandstop filter using the geometric symmetric mapping:
	%
	% 	S ->  Wi^2 s/(s^2 + Wi^2) 
	%
	% It is necessary that Wc1*Wc2 = Ws1*Ws2 = Wi^2

	% Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% Author: 			Oscar Gustafsson 
	% Modified by: 		LW 2003-09-19, 2004-09-22
	% Copyright:		by authors - not released for commercial use
	% Version: 			1
	% Known bugs:		
	% Report bugs to:	Wanhammar@gmail.com
	%
	lz = length(Z);
	lp = length(P);
	
	% Transform LP zeros to BS zeros where Wi2 = Wi^2
	for i = 1:lz
		Zbs(2*i-1) = Wi2/(2*Z(i)) + sqrt(Wi2^2/((Z(i)^2)*4)-Wi2);
		Zbs(2*i) = Wi2/(2*Z(i)) - sqrt(Wi2^2/((Z(i)^2)*4)-Wi2);
	end
	% Transform LP poles to BS poles
	for i = 1:lp
		Pbs(2*i-1) = Wi2/(2*P(i)) + sqrt(Wi2^2/((P(i)^2)*4)-Wi2);
		Pbs(2*i) = Wi2/(2*P(i)) - sqrt(Wi2^2/((P(i)^2)*4)-Wi2);
	end
	% Transform any zeros at infinity 
	for i = lz+1:lp
		Zbs(2*i-1) = j*sqrt(Wi2);
		Zbs(2*i) = -j*sqrt(Wi2);
	end
	Zbs = cplxpair(Zbs)';
	Pbs = cplxpair(Pbs)';
	x = prod(Z);
	if x ~= 0
		G = x*G;
	end
	Gbs = real(G/prod(P));
